/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets;

import io.github.kosmx.emotes.arch.executor.types.TextImpl;
import io.github.kosmx.emotes.arch.gui.screen.IDrawableImpl;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.screen.widget.IEmoteListWidgetHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public abstract class AbstractEmoteListWidget<E extends AbstractEmoteEntry<E>>
extends class_4280<E>
implements IEmoteListWidgetHelper<class_4587, class_364>,
IDrawableImpl {
    protected List<E> emotes = new ArrayList();
    private final class_437 screen;

    @Override
    public IEmoteListWidgetHelper.IEmoteEntry getSelectedEntry() {
        return (IEmoteListWidgetHelper.IEmoteEntry)this.method_25334();
    }

    public AbstractEmoteListWidget(class_310 minecraftClient, int i, int j, int k, int l, int m, class_437 screen) {
        super(minecraftClient, i, j, k, l, m);
        this.field_22744 = false;
        this.screen = screen;
    }

    public int method_25322() {
        return this.field_22742 - 5;
    }

    protected abstract E newEmoteEntry(class_310 var1, EmoteHolder var2);

    @Override
    public void emotesSetLeftPos(int left) {
        this.method_25333(left);
    }

    @Override
    public void setEmotes(Iterable<EmoteHolder> list, boolean showInvalid) {
        this.emotes = new ArrayList();
        for (EmoteHolder emoteHolder : list) {
            this.emotes.add(this.newEmoteEntry(class_310.method_1551(), emoteHolder));
        }
        if (showInvalid) {
            for (EmoteHolder emoteHolder : this.getEmptyEmotes()) {
                this.emotes.add(this.newEmoteEntry(class_310.method_1551(), emoteHolder));
            }
        }
        this.emotes.sort(Comparator.comparing(o -> o.emote.name.getString().toLowerCase()));
        this.filter(() -> "");
    }

    @Override
    public void filter(Supplier<String> string) {
        this.method_25339();
        for (AbstractEmoteEntry emote : this.emotes) {
            if (!emote.emote.name.getString().toLowerCase().contains(string.get()) && !emote.emote.description.getString().toLowerCase().contains(string.get()) && !emote.emote.author.getString().toLowerCase().equals(string.get())) continue;
            this.method_25321((class_350.class_351)emote);
        }
        this.method_25307(0.0);
    }

    @Override
    public void renderThis(class_4587 matrices, int mouseX, int mouseY, float tickDelta) {
        this.method_25394(matrices, mouseX, mouseY, tickDelta);
    }

    protected int method_25329() {
        return this.field_19087 - 6;
    }

    protected boolean method_25316() {
        return this.screen.method_25399() == this;
    }

    @Override
    public AbstractEmoteListWidget<E> get() {
        return this;
    }

    public static abstract class AbstractEmoteEntry<T extends AbstractEmoteEntry<T>>
    extends class_4280.class_4281<T>
    implements IEmoteListWidgetHelper.IEmoteEntry<class_4587>,
    IDrawableImpl {
        protected final class_310 client;
        public final EmoteHolder emote;

        public AbstractEmoteEntry(class_310 client, EmoteHolder emote) {
            this.client = client;
            this.emote = emote;
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.renderThis(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
        }

        @Override
        public EmoteHolder getEmote() {
            return this.emote;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.onPressed();
                return true;
            }
            return false;
        }

        public class_2561 method_37006() {
            return ((TextImpl)this.emote.name).get();
        }

        protected abstract void onPressed();
    }
}

